import { initGetToken } from './tokenUtil.js';
// 插件安装初始化
chrome.runtime.onInstalled.addListener(() => {
  console.log('表单填充插件（直接赋值版）已安装');
  // 初始化本地存储（可扩展自定义数据）
  chrome.storage.local.set({
    customUserData: {},
    customMatchRules: {}
  });
});

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.type === 'RECORD_SAVED') {
      // 延迟处理，确保页面跳转完成
      setTimeout(() => {
          // 通知content script处理暂存的记录
          chrome.tabs.query({active: true, currentWindow: true}, (tabs) => {
              if (tabs[0]) {
                  chrome.tabs.sendMessage(tabs[0].id, {
                      type: 'PROCESS_PENDING_RECORD',
                      recordKey: request.recordKey
                  }, (response) => {
                      if (chrome.runtime.lastError) {
                          console.error('发送消息失败：', chrome.runtime.lastError);
                      } else {
                          console.log('处理记录结果：', response);
                      }
                  });
              }
          });
      }, 1000); // 延迟1秒，确保新页面加载完成
      
      sendResponse({received: true});
  }
  return true;
});

// 监听消息（可选扩展）
// chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
//   console.log(message);
//   (async () => {
//     console.log(message);
//   if (message.type === 'getUserData') {
//     chrome.storage.local.get('customUserData', (data) => {
//       sendResponse(data.customUserData || {});
//     });
//     return true; // 保持消息通道开放
//   }
//   if (message.type === 'getToken') {
//     const token = await refreshToken();
//     sendResponse({ code: 200, data: token, msg: '获取Token成功' });
//     return true; // 保持消息通道开放
//   }
//   if (message.type === 'GET_COOKIE') {
//     const { url, name } = message;
//     // 调用后台的 getCookie 函数获取 Cookie
//     getCookie(url, name).then((cookieValue) => {
//       // 将结果返回给 content script
//       sendResponse({ cookieValue });
//     });
//     // 关键：因为是异步操作，必须返回 true，告诉 Chrome 等待 sendResponse 执行完成
//     return true;
//   }

//   });

// });


chrome.runtime.onMessage.addListener(async (message, sender, sendResponse) => {
  console.log(message);
  try {
    const { action } = message;
    let result = { code: 200, data: null, msg: '执行成功' };
    // 根据action执行对应Token方法
    switch (action) {
      case 'getToken': // 获取本地Token（最常用）
        result.data = await refreshToken();
        result.msg = result.data ? '获取本地Token成功' : '本地无有效Token';
        break;
      default: // 未知指令
        result = { code: 400, data: null, msg: `未知操作指令：${action}` };
    }
    console.log(result);
    sendResponse(result); // 执行成功，返回结果
  } catch (err) {
    // 全局异常兜底，确保任何错误都能返回响应，不终止回调
    sendResponse({
      code: 500,
      data: null,
      msg: `执行失败：${err.message || '未知错误'}`
    });
    console.error('消息监听执行异常：', err);
  }
  // 【V3关键】必须返回true，告知Chrome等待异步sendResponse执行完成
  return true;
});


async function getCookie(url, name) {
  return new Promise((resolve) => {
    chrome.cookies.get(
      { url: url, name: name },
      (cookie) => resolve(cookie ? cookie.value : null)
    );
  });
}




// 插件启动时，立即获取 Token 并存入 Storage
initGetToken();



// ========== 1. 监听标签页事件 ==========
// 新标签页创建时触发
// chrome.tabs.onCreated.addListener((tab) => {
//   console.log("【标签页事件】新标签页创建:", tab.id, tab.url);
// });

// 标签页更新（如URL变化、加载完成）时触发
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  // 仅监听页面加载完成的事件
  if (changeInfo.status === "complete") {
    initGetToken();
    console.log("【标签页事件】页面加载完成:", tabId, tab.url);
  }
});







// // ========== 2. 监听网络请求事件 ==========
// // chrome.webRequest.onBeforeRequest.addListener(
// //   (details) => {
// //     console.log("【网络请求事件】请求触发:", details.url, details.method);
// //   },
// //   { urls: ["<all_urls>"] }, // 匹配的URL范围（需和manifest一致）
// //   [] // 可选：如需拦截请求可加["blocking"]，否则留空
// // );

// // ========== 3. 监听来自前端的消息（如popup/content script） ==========
// // chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
// //   console.log("【消息事件】收到消息:", message, "来自:", sender.tab?.id);
// //   // 回复消息给发送方
// //   sendResponse({ status: "success", data: "已收到你的消息：" + message.content });
// // });

// // ========== 4. 防止Service Worker休眠（核心！） ==========
// // 原理：Chrome的Service Worker默认30秒闲置休眠，用alarms每25秒唤醒一次
// // 创建定时闹钟（25秒执行一次）
// chrome.alarms.create("keepAlive", { periodInMinutes: 25/60 }); // 25秒 = 25/60 分钟

// // 监听闹钟事件，唤醒Service Worker
// chrome.alarms.onAlarm.addListener((alarm) => {
//   if (alarm.name === "keepAlive") {
//     console.log("【唤醒】Service Worker被闹钟唤醒，保持活跃");
//     // 执行简单操作（如更新存储），避免被立即休眠
//     chrome.storage.local.set({ lastWakeTime: new Date().toISOString() });
//   }
// });

// // ========== 5. 插件安装/更新时初始化 ==========
// chrome.runtime.onInstalled.addListener(() => {
//   console.log("【初始化】插件安装完成，后台开始运行");
//   // 确保安装后立即创建唤醒闹钟
//   chrome.alarms.create("keepAlive", { periodInMinutes: 25/60 });
// });